/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.marker;

import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.RegistrarAntiqueAtlas;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.marker.MarkersData;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class MarkersDataHandler {
    private static final String MARKERS_DATA_PREFIX = "aaMarkers_";
    private final Map<String, MarkersData> markersDataClientCache = new ConcurrentHashMap<String, MarkersData>();

    public MarkersData getMarkersData(ItemStack stack, World world) {
        if (stack.func_77973_b() == RegistrarAntiqueAtlas.ATLAS) {
            return this.getMarkersData(stack.func_77952_i(), world);
        }
        return null;
    }

    public MarkersData getMarkersData(int atlasID, World world) {
        String key = this.getMarkersDataKey(atlasID);
        MarkersData data = null;
        if (world.field_72995_K) {
            data = this.markersDataClientCache.get(key);
        }
        if (data == null) {
            data = (MarkersData)world.func_72943_a(MarkersData.class, key);
            if (data == null) {
                data = new MarkersData(key);
                world.func_72823_a(key, (WorldSavedData)data);
            }
            if (world.field_72995_K) {
                this.markersDataClientCache.put(key, data);
                this.addGlobalMarkers(data);
            }
        }
        return data;
    }

    private void addGlobalMarkers(MarkersData data) {
        GlobalMarkersData global = AntiqueAtlasMod.globalMarkersData.getData();
        for (int dim : global.getVisitedDimensions()) {
            for (Marker marker : global.getMarkersInDimension(dim)) {
                Marker localCopy = new Marker(-marker.getId(), marker.getType(), marker.getLabel(), marker.getDimension(), marker.getX(), marker.getZ(), marker.isVisibleAhead());
                data.loadMarker(localCopy);
            }
        }
    }

    public Collection<MarkersData> getAllLoadedMarkersData() {
        return this.markersDataClientCache.values();
    }

    private String getMarkersDataKey(int atlasID) {
        return MARKERS_DATA_PREFIX + atlasID;
    }

    @SubscribeEvent
    public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        this.markersDataClientCache.clear();
    }
}

